#include <iostream>
#include <vector>
#include <utility>
#include <algorithm>
#include <map>
#include <string>
#include <sstream>
#include <unordered_map>
#include <unordered_set>

bool consume_html(std::string::const_iterator& b, std::string::const_iterator& e)
{
	if (b == e)
		return true;

	while (b != e)
	{
		if (*b != '<')
			return false;
		++b;
		if (b != e && *b == '/')
		{
			--b;
			return true;
		}
		std::stringstream tag_name;
		while (b != e && *b != '>')
		{
			tag_name << *b;
			++b;
		}
		if (b == e)
			return false;
		++b;

		if (!consume_html(b, e))
			return false;
		if (b == e || *b != '<')
			return false;
		++b;
		if (b == e || *b != '/')
			return false;
		++b;
		std::stringstream close_tag_name;
		while (b != e && *b != '>')
		{
			close_tag_name << *b;
			++b;
		}
		if (b == e || *b != '>')
			return false;
		++b;
		if (tag_name.str() != close_tag_name.str())
			return false;
	}
	return true;
}

int main()
{
	std::string s;
	std::getline(std::cin, s);

	auto b = s.cbegin(), e = s.cend();
	if (consume_html(b, e) && b == e)
		std::cout << "YES" << std::endl;
	else
		std::cout << "NO" << std::endl;
}
